<?php

// Smart Plugin Templates Header

function templates_header_callback() {

    $current_article_generate_limit = 0;
    $api_key  = sanitize_text_field( get_user_meta(1, 'smart_plugin_license_key', true) );
    $site_url = esc_url_raw( get_site_url() );

    $response = wp_remote_post('https://smart-plugin.com/wp-json/article-limit/v1/receive-data/', [
        'headers' => ['Content-Type' => 'application/json'],
        'body'    => json_encode([
            'api_key'  => $api_key,
            'site_url' => $site_url,
        ]),
    ]);

    $body = json_decode(wp_remote_retrieve_body($response), true);

    if (!empty($body['status']) && $body['status'] === 'success') {

        $current_article_generate_limit = $body['limit'];

    }

    ?>

    <div class="templates_header">

        <h2>
            <svg fill="#ffffff" width="256px" height="256px" viewBox="0 -32 576 576" xmlns="http://www.w3.org/2000/svg" stroke="#ffffff"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><path d="M208 0c-29.9 0-54.7 20.5-61.8 48.2-.8 0-1.4-.2-2.2-.2-35.3 0-64 28.7-64 64 0 4.8.6 9.5 1.7 14C52.5 138 32 166.6 32 200c0 12.6 3.2 24.3 8.3 34.9C16.3 248.7 0 274.3 0 304c0 33.3 20.4 61.9 49.4 73.9-.9 4.6-1.4 9.3-1.4 14.1 0 39.8 32.2 72 72 72 4.1 0 8.1-.5 12-1.2 9.6 28.5 36.2 49.2 68 49.2 39.8 0 72-32.2 72-72V64c0-35.3-28.7-64-64-64zm368 304c0-29.7-16.3-55.3-40.3-69.1 5.2-10.6 8.3-22.3 8.3-34.9 0-33.4-20.5-62-49.7-74 1-4.5 1.7-9.2 1.7-14 0-35.3-28.7-64-64-64-.8 0-1.5.2-2.2.2C422.7 20.5 397.9 0 368 0c-35.3 0-64 28.6-64 64v376c0 39.8 32.2 72 72 72 31.8 0 58.4-20.7 68-49.2 3.9.7 7.9 1.2 12 1.2 39.8 0 72-32.2 72-72 0-4.8-.5-9.5-1.4-14.1 29-12 49.4-40.6 49.4-73.9z"></path></g></svg>
            <div class="plugin_name">
                <strong>Smart Plugin</strong>
                <span>AI-powered content generation for your blog</span>
            </div>
        </h2>

        <ul class="templates_header_details">
            <li>
                <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path fill-rule="evenodd" clip-rule="evenodd" d="M14 22H10C6.22876 22 4.34315 22 3.17157 20.8284C2 19.6569 2 17.7712 2 14V10C2 6.22876 2 4.34315 3.17157 3.17157C4.34315 2 6.23869 2 10.0298 2C10.6358 2 11.1214 2 11.53 2.01666C11.5166 2.09659 11.5095 2.17813 11.5092 2.26057L11.5 5.09497C11.4999 6.19207 11.4998 7.16164 11.6049 7.94316C11.7188 8.79028 11.9803 9.63726 12.6716 10.3285C13.3628 11.0198 14.2098 11.2813 15.0569 11.3952C15.8385 11.5003 16.808 11.5002 17.9051 11.5001L18 11.5001H21.9574C22 12.0344 22 12.6901 22 13.5629V14C22 17.7712 22 19.6569 20.8284 20.8284C19.6569 22 17.7712 22 14 22ZM5.25 14.5C5.25 14.0858 5.58579 13.75 6 13.75H14C14.4142 13.75 14.75 14.0858 14.75 14.5C14.75 14.9142 14.4142 15.25 14 15.25H6C5.58579 15.25 5.25 14.9142 5.25 14.5ZM5.25 18C5.25 17.5858 5.58579 17.25 6 17.25H11.5C11.9142 17.25 12.25 17.5858 12.25 18C12.25 18.4142 11.9142 18.75 11.5 18.75H6C5.58579 18.75 5.25 18.4142 5.25 18Z" fill="#ffffff"></path> <path d="M19.3517 7.61665L15.3929 4.05375C14.2651 3.03868 13.7012 2.53114 13.0092 2.26562L13 5.00011C13 7.35713 13 8.53564 13.7322 9.26787C14.4645 10.0001 15.643 10.0001 18 10.0001H21.5801C21.2175 9.29588 20.5684 8.71164 19.3517 7.61665Z" fill="#ffffff"></path> </g></svg>
                <strong><?php echo (int) get_user_meta(1, 'smart_plugin_articles_generated', true); ?></strong>
                <span>Articles Generated</span>
            </li>
            <li>
                <svg fill="#ffffff" height="200px" width="200px" version="1.1" id="Icons" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 32 32" xml:space="preserve" stroke="#ffffff"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g> <path d="M28,5h-6V3c0-0.6-0.4-1-1-1s-1,0.4-1,1v2h-8V3c0-0.6-0.4-1-1-1s-1,0.4-1,1v2H4C3.4,5,3,5.4,3,6v4h26V6C29,5.4,28.6,5,28,5z "></path> <path d="M3,28c0,0.6,0.4,1,1,1h18v-6c0-0.5,0.4-0.9,0.9-1c1.4-0.1,3.5-1.6,4.3-2.6C28.9,17.2,29,16,29,16v-4H3V28z"></path> <path d="M24,23.8V29c0.2,0,0.3-0.1,0.5-0.2l0.9-0.9c2-2,3.2-4.6,3.5-7.4c0,0.1-0.1,0.1-0.1,0.2C27.8,21.9,25.8,23.3,24,23.8z"></path> </g> </g></svg>
                <strong>
                    <?php 
                        $schedule_lists = get_user_meta(1, 'schedule_lists', true);
                        $not_done_count = 0;
                        if (is_array($schedule_lists)) {

                            foreach ($schedule_lists as $schedule) {  if (!isset($schedule['done'])) { $not_done_count++; } }
                        }

                        echo $not_done_count;
                    ?>
                </strong>
                <span>Scheduled Posts</span>
            </li>
            <li>
                <svg width="256px" height="256px" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" fill="#ffffffff" class="bi bi-stars"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M7.657 6.247c.11-.33.576-.33.686 0l.645 1.937a2.89 2.89 0 0 0 1.829 1.828l1.936.645c.33.11.33.576 0 .686l-1.937.645a2.89 2.89 0 0 0-1.828 1.829l-.645 1.936a.361.361 0 0 1-.686 0l-.645-1.937a2.89 2.89 0 0 0-1.828-1.828l-1.937-.645a.361.361 0 0 1 0-.686l1.937-.645a2.89 2.89 0 0 0 1.828-1.828l.645-1.937zM3.794 1.148a.217.217 0 0 1 .412 0l.387 1.162c.173.518.579.924 1.097 1.097l1.162.387a.217.217 0 0 1 0 .412l-1.162.387A1.734 1.734 0 0 0 4.593 5.69l-.387 1.162a.217.217 0 0 1-.412 0L3.407 5.69A1.734 1.734 0 0 0 2.31 4.593l-1.162-.387a.217.217 0 0 1 0-.412l1.162-.387A1.734 1.734 0 0 0 3.407 2.31l.387-1.162zM10.863.099a.145.145 0 0 1 .274 0l.258.774c.115.346.386.617.732.732l.774.258a.145.145 0 0 1 0 .274l-.774.258a1.156 1.156 0 0 0-.732.732l-.258.774a.145.145 0 0 1-.274 0l-.258-.774a1.156 1.156 0 0 0-.732-.732L9.1 2.137a.145.145 0 0 1 0-.274l.774-.258c.346-.115.617-.386.732-.732L10.863.1z"></path> </g></svg>
                <strong><?php echo $current_article_generate_limit; ?></strong>
                <span>Generations Left Today</span>
            </li>
        </ul>

    </div>

    <?php

}