<?php
/**
 * Plugin Name: Smart Plugin
 * Description: Generates blog posts using Smart Plugin API
 * Version: 1.0.0
 * Author: Smart Plugin Team
 */

if (!defined('ABSPATH')) exit;

// Load Composer autoloader if available
if ( file_exists( __DIR__ . '/vendor/autoload.php' ) ) { require_once __DIR__ . '/vendor/autoload.php'; }

// Load plugin module files
require_once plugin_dir_path(__FILE__) . 'modules/enqueue_scripts.php';
require_once plugin_dir_path(__FILE__) . 'modules/activation_hook.php';
require_once plugin_dir_path(__FILE__) . 'modules/deactivation_hook.php';
require_once plugin_dir_path(__FILE__) . 'modules/admin_menu.php';
require_once plugin_dir_path(__FILE__) . 'modules/templates_header.php';

// Include admin page templates
require_once plugin_dir_path(__FILE__) . 'templates/schedule_page.php';
require_once plugin_dir_path(__FILE__) . 'templates/generation_page.php';
require_once plugin_dir_path(__FILE__) . 'templates/license_page.php';

// Include AJAX handlers
require_once plugin_dir_path(__FILE__) . 'templates/ajax/remove_schedule.php';
require_once plugin_dir_path(__FILE__) . 'templates/ajax/add_schedule.php';
require_once plugin_dir_path(__FILE__) . 'templates/ajax/update_schedule.php';
require_once plugin_dir_path(__FILE__) . 'templates/ajax/get_taxonomies.php';
require_once plugin_dir_path(__FILE__) . 'templates/ajax/generate_article.php';
require_once plugin_dir_path(__FILE__) . 'templates/ajax/validate_api.php';
require_once plugin_dir_path(__FILE__) . 'templates/ajax/get_schedule_form.php';

// Include Cron job related files
require_once plugin_dir_path(__FILE__) . 'templates/cron/cron_schedules.php';
require_once plugin_dir_path(__FILE__) . 'templates/cron/cron_schedules_event.php';
