<?php

// Schedule Forms

add_action('wp_ajax_get_schedule_form', 'handle_get_schedule_form');

function handle_get_schedule_form() {

    $multimodel = get_user_meta(1, 'smart_plugin_multimodel', true);
    $generateImage = get_user_meta(1, 'smart_plugin_generateImage', true);
    $schedule = get_user_meta(1, 'smart_plugin_schedule', true);

    $isMultimodel = (bool) $multimodel;
    $isGenerateImage = (bool) $generateImage;
    $isSchedule = (bool) $schedule;

    if( $isSchedule ) {

        if (isset($_POST['update_schedule_id'])) {

        $schedule_lists = get_user_meta(1, 'schedule_lists', true);

        $schedule_data = $schedule_lists[$_POST['update_schedule_id']];

        ob_start();

        ?>

            <form method="post" id="form_generate_request" class="form_generate_request update_form_generate_request">

                <div class="close_pop"><svg style="width: 14px; height: 30px; fill: #ffffffff; cursor: pointer;" class="remove_uploaded_image" fill="#000000" width="256px" height="256px" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M0 14.545L1.455 16 8 9.455 14.545 16 16 14.545 9.455 8 16 1.455 14.545 0 8 6.545 1.455 0 0 1.455 6.545 8z" fill-rule="evenodd"></path> </g></svg></div>

                <h2>Update schedule</h2>

                <input type="hidden" id="schedule_id" name="schedule_id" value="<?php echo $_POST['update_schedule_id']; ?>">

                <label for="title"><span>Title</span> <input type="text" name="title" id="title" value="<?php echo $schedule_data['title'];?>" required></label>

                <label for="prompt"><span>Prompt</span>
                    <textarea name="prompt" id="prompt" required><?php echo $schedule_data['prompt'];?></textarea>
                </label>

                <label for="language"><span>Language</span>
                    <select name="language" id="language" required>
                        <option value="English" <?php selected($schedule_data['language'], 'English'); ?>>English</option>
                        <option value="Bulgarian" <?php selected($schedule_data['language'], 'Bulgarian'); ?>>Bulgarian</option>
                        <option value="Czech" <?php selected($schedule_data['language'], 'Czech'); ?>>Czech</option>
                        <option value="Danish" <?php selected($schedule_data['language'], 'Danish'); ?>>Danish</option>
                        <option value="Dutch" <?php selected($schedule_data['language'], 'Dutch'); ?>>Dutch</option>
                        <option value="Estonian" <?php selected($schedule_data['language'], 'Estonian'); ?>>Estonian</option>
                        <option value="Finnish" <?php selected($schedule_data['language'], 'Finnish'); ?>>Finnish</option>
                        <option value="French" <?php selected($schedule_data['language'], 'French'); ?>>French</option>
                        <option value="German" <?php selected($schedule_data['language'], 'German'); ?>>German</option>
                        <option value="Greek" <?php selected($schedule_data['language'], 'Greek'); ?>>Greek</option>
                        <option value="Irish" <?php selected($schedule_data['language'], 'Irish'); ?>>Irish</option>
                        <option value="Italian" <?php selected($schedule_data['language'], 'Italian'); ?>>Italian</option>
                        <option value="Latvian" <?php selected($schedule_data['language'], 'Latvian'); ?>>Latvian</option>
                        <option value="Lithuanian" <?php selected($schedule_data['language'], 'Lithuanian'); ?>>Lithuanian</option>
                        <option value="Maltese" <?php selected($schedule_data['language'], 'Maltese'); ?>>Maltese</option>
                        <option value="Polish" <?php selected($schedule_data['language'], 'Polish'); ?>>Polish</option>
                        <option value="Portuguese" <?php selected($schedule_data['language'], 'Portuguese'); ?>>Portuguese</option>
                        <option value="Romanian" <?php selected($schedule_data['language'], 'Romanian'); ?>>Romanian</option>
                        <option value="Slovak" <?php selected($schedule_data['language'], 'Slovak'); ?>>Slovak</option>
                        <option value="Slovenian" <?php selected($schedule_data['language'], 'Slovenian'); ?>>Slovenian</option>
                        <option value="Spanish" <?php selected($schedule_data['language'], 'Spanish'); ?>>Spanish</option>
                        <option value="Swedish" <?php selected($schedule_data['language'], 'Swedish'); ?>>Swedish</option>
                    </select>
                </label>

                <label for="post_type"><span>Post Type</span> 
                    <select name="post_type" id="post_type" required>
                        <?php
                            $args = array(
                                'public'   => true,
                                '_builtin' => false
                            );

                            $output = 'names';
                            $post_types = get_post_types($args, $output);

                            $builtin = ['post', 'page'];

                            foreach ($builtin as $type) {

                                echo '<option value="' . esc_attr($type) . '" '. selected($schedule_data['post_type'], $type, false) .'>' . esc_html(ucfirst($type)) . '</option>';
                            }

                            foreach ($post_types as $post_type) {

                                echo '<option value="' . esc_attr($post_type) . '" '. selected($schedule_data['post_type'], $post_type, false) .'>' . esc_html(ucfirst($post_type)) . '</option>';
                            }
                        ?>
                    </select>
                </label>

                <style>#taxonomy-field{display: inline;}</style>

                <div id="taxonomy-field">
                    <?php
                        $selected_terms = $schedule_data['categories']['texanomy_category'] ?? [];
                        $post_type = 'post';
                        $taxonomies = get_object_taxonomies($post_type, 'objects');

                        if (!empty($taxonomies)) :
                            foreach ($taxonomies as $taxonomy) :
                                if ($taxonomy->hierarchical) :
                                    $terms = get_terms(array(
                                        'taxonomy' => $taxonomy->name,
                                        'hide_empty' => false,
                                    ));
                                    if (!empty($terms) && !is_wp_error($terms)) : ?>
                                        <label for="texanomy_<?php echo esc_attr($taxonomy->name); ?>"><span><?php echo esc_html($taxonomy->label); ?></span>
                                            <select name="texanomy_<?php echo esc_attr($taxonomy->name); ?>" id="texanomy_<?php echo esc_attr($taxonomy->name); ?>">
                                                <option value="">Select category</option>
                                                <?php foreach ($terms as $term) : ?>
                                                    <option value="<?php echo esc_attr($term->term_id); ?>" <?php selected(in_array($term->term_id, $selected_terms)); ?>>
                                                        <?php echo esc_html($term->name); ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            </select>
                                        </label>
                                    <?php endif;
                                endif;
                            endforeach;
                        endif;
                    ?>
                </div>

                <script>
                    jQuery(document).ready(function($) {

                        $('#post_type').change(function() {
                            var taxonomy_container = $('#taxonomy-field');
                            var postType = $(this).val();
                            $.ajax({
                                url: ajaxurl,
                                method: 'POST',
                                data: {
                                    action: 'get_taxonomies_by_post_type',
                                    post_type: postType
                                },
                                success: function(response) {
                                    taxonomy_container.html(response.data);
                                }
                            });
                        });

                    });
                </script>

                <input type="hidden" name="model" id="modelInput" value="<?php echo $schedule_data['model'];?>" required>

                <?php if($isMultimodel) { ?>
                    
                    <div class=switch-container><div class=switch-label>DeepSeek</div> <label class=switch><input id=modelSwitch type=checkbox <?php if($schedule_data['model'] == "chatgpt") { echo "checked"; } ?>> <div class=slider></div></label> <div class=switch-label>ChatGPT</div></div>
                    
                    <script>switchInput=document.getElementById("modelSwitch"),modelInput=document.getElementById("modelInput");switchInput.addEventListener("change",()=>{let e=switchInput.checked?"chatgpt":"deepseek";modelInput.value=e});</script>
                
                <?php } ?>

                <label for="upload-article-image"><span>Upload article image</span>

                    <?php 
                        $uploaded_image_url = 'Select Image';

                        if( !empty( $schedule_data['article_image_id'] ) ) {

                            $uploaded_image_url = wp_get_attachment_image_url($schedule_data['article_image_id'], 'full'); 
                            
                        }
                    ?>

                    <div id="upload-article-image"><?php echo $uploaded_image_url; ?></div>

                    <svg style="width: 10px;height: 50px;fill: #bf3e3e;cursor: pointer;margin-left: -20px;" class="remove_uploaded_image" fill="#000000" width="256px" height="256px" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M0 14.545L1.455 16 8 9.455 14.545 16 16 14.545 9.455 8 16 1.455 14.545 0 8 6.545 1.455 0 0 1.455 6.545 8z" fill-rule="evenodd"></path> </g></svg>

                    <input id="article-image-id" name="article-image-id" type="hidden" value="<?php echo $schedule_data['article_image_id'];?>">

                </label>

                <?php if($isGenerateImage) { ?>

                    <label class="checkbox-container" for="generate-image"><input id="generate-image" name="generate-image" type="checkbox" <?php if( $schedule_data['generateImage'] == 'true' ) { echo "checked"; } ?>> Generate article image</label>

                <?php } ?>

                <label for="schedule_datetime"><span>Schedule Datetime</span> 

                    <input type="datetime-local" id="schedule_datetime" name="schedule_datetime" value="<?php echo $schedule_data['schedule_datetime'];?>" required>

                </label>

                <button id="update_schedule" type="submit" class="button button-primary">
                    <svg width="256px" height="256px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M4 12.6111L8.92308 17.5L20 6.5" stroke="#ffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>
                    Update schedule
                </button>

            </form>
        <?php

        wp_send_json_success(ob_get_clean());
            
        } else {

        ob_start();

        ?>

            <form method="post" id="form_generate_request" class="form_generate_request add_form_generate_request">

                <div class="close_pop"><svg style="width: 14px; height: 30px; fill: #ffffffff; cursor: pointer;" class="remove_uploaded_image" fill="#000000" width="256px" height="256px" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M0 14.545L1.455 16 8 9.455 14.545 16 16 14.545 9.455 8 16 1.455 14.545 0 8 6.545 1.455 0 0 1.455 6.545 8z" fill-rule="evenodd"></path> </g></svg></div>

                <h2>Add schedule</h2>

                <label for="title"><span>Title</span> <input type="text" name="title" id="title" required></label>

                <label for="prompt"><span>Prompt</span>
                    <textarea name="prompt" id="prompt" required></textarea>
                </label>

                <label for="language"><span>Language</span>
                    <select name="language" id="language" required>
                        <option value="English">English</option>
                        <option value="Bulgarian">Bulgarian</option>
                        <option value="Czech">Czech</option>
                        <option value="Danish">Danish</option>
                        <option value="Dutch">Dutch</option>
                        <option value="Estonian">Estonian</option>
                        <option value="Finnish">Finnish</option>
                        <option value="French">French</option>
                        <option value="German">German</option>
                        <option value="Greek">Greek</option>
                        <option value="Irish">Irish</option>
                        <option value="Italian">Italian</option>
                        <option value="Latvian">Latvian</option>
                        <option value="Lithuanian">Lithuanian</option>
                        <option value="Maltese">Maltese</option>
                        <option value="Polish">Polish</option>
                        <option value="Portuguese">Portuguese</option>
                        <option value="Romanian">Romanian</option>
                        <option value="Slovak">Slovak</option>
                        <option value="Slovenian">Slovenian</option>
                        <option value="Spanish">Spanish</option>
                        <option value="Swedish">Swedish</option>
                    </select>
                </label>

                <label for="post_type"><span>Post Type</span> 
                    <select name="post_type" id="post_type" required>
                        <?php
                            $args = array(
                                'public'   => true,
                                '_builtin' => false
                            );

                            $output = 'names';
                            $post_types = get_post_types($args, $output);

                            $builtin = ['post', 'page'];

                            foreach ($builtin as $type) {

                                echo '<option value="' . esc_attr($type) . '">' . esc_html(ucfirst($type)) . '</option>';
                            }

                            foreach ($post_types as $post_type) {

                                echo '<option value="' . esc_attr($post_type) . '">' . esc_html(ucfirst($post_type)) . '</option>';
                            }
                        ?>
                    </select>
                </label>

                <style>#taxonomy-field{display: inline;}</style>

                <div id="taxonomy-field">
                    <?php
                        $post_type = 'post';
                        $taxonomies = get_object_taxonomies($post_type, 'objects');

                        if (!empty($taxonomies)) :
                            foreach ($taxonomies as $taxonomy) :
                                if ($taxonomy->hierarchical) :
                                    $terms = get_terms(array(
                                        'taxonomy' => $taxonomy->name,
                                        'hide_empty' => false,
                                    ));
                                    if (!empty($terms) && !is_wp_error($terms)) : ?>
                                        <label for="texanomy_<?php echo esc_attr($taxonomy->name); ?>"><span><?php echo esc_html($taxonomy->label); ?></span>
                                            <select name="texanomy_<?php echo esc_attr($taxonomy->name); ?>" id="texanomy_<?php echo esc_attr($taxonomy->name); ?>">
                                                <option value="">Select category</option>
                                                <?php foreach ($terms as $term) : ?>
                                                    <option value="<?php echo esc_attr($term->term_id); ?>">
                                                        <?php echo esc_html($term->name); ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            </select>
                                        </label>
                                    <?php endif;
                                endif;
                            endforeach;
                        endif;
                    ?>
                </div>

                <script>
                    jQuery(document).ready(function($) {

                        $('#post_type').change(function() {
                            var taxonomy_container = $('#taxonomy-field');
                            var postType = $(this).val();
                            $.ajax({
                                url: ajaxurl,
                                method: 'POST',
                                data: {
                                    action: 'get_taxonomies_by_post_type',
                                    post_type: postType
                                },
                                success: function(response) {
                                    taxonomy_container.html(response.data);
                                }
                            });
                        });

                    });
                </script>

                <input type="hidden" name="model" id="modelInput" value="deepseek" required>

                <?php if($isMultimodel) { ?>
                    
                    <div class=switch-container><div class=switch-label>DeepSeek</div> <label class=switch><input id=modelSwitch type=checkbox> <div class=slider></div></label> <div class=switch-label>ChatGPT</div></div>
                    
                    <script>switchInput=document.getElementById("modelSwitch"),modelInput=document.getElementById("modelInput");switchInput.addEventListener("change",()=>{let e=switchInput.checked?"chatgpt":"deepseek";modelInput.value=e});</script>
                
                <?php } ?>

                <label for="upload-article-image"><span>Upload article image</span>

                    <div id="upload-article-image">Select Image</div>

                    <svg style="width: 10px;height: 50px;fill: #bf3e3e;cursor: pointer;margin-left: -20px;" class="remove_uploaded_image" fill="#000000" width="256px" height="256px" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M0 14.545L1.455 16 8 9.455 14.545 16 16 14.545 9.455 8 16 1.455 14.545 0 8 6.545 1.455 0 0 1.455 6.545 8z" fill-rule="evenodd"></path> </g></svg>

                    <input id="article-image-id" name="article-image-id" type="hidden">

                </label>

                <?php if($isGenerateImage) { ?>

                    <label class="checkbox-container" for="generate-image"><input id="generate-image" name="generate-image" type="checkbox"> Generate article image</label>

                <?php } ?>

                <label for="schedule_datetime"><span>Schedule Datetime</span> 

                    <input type="datetime-local" id="schedule_datetime" name="schedule_datetime" required>

                </label>

                <button id="add_schedule" type="submit" class="button button-primary">
                    <svg width="256px" height="256px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M4 12.6111L8.92308 17.5L20 6.5" stroke="#ffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>
                    Add schedule
                </button>

            </form>
        <?php

        wp_send_json_success(ob_get_clean());

        }
    }

}
