<?php

// Smart Plugin Taxonomies

add_action('wp_ajax_get_taxonomies_by_post_type', 'handle_get_taxonomies_by_post_type');

function handle_get_taxonomies_by_post_type() {

    if (!isset($_POST['post_type'])) {

        wp_send_json_error('Missing post_type');
    }

    $post_type = sanitize_text_field($_POST['post_type']);
    $taxonomies = get_object_taxonomies($post_type, 'objects');

    ob_start();

    if (!empty($taxonomies)) :
        foreach ($taxonomies as $taxonomy) :
            if ($taxonomy->hierarchical) :
                $terms = get_terms(array(
                    'taxonomy' => $taxonomy->name,
                    'hide_empty' => false,
                ));
                if (!empty($terms) && !is_wp_error($terms)) : ?>
                    <label for="post_categories_<?php echo esc_attr($taxonomy->name); ?>"><span><?php echo esc_html($taxonomy->label); ?></span>
                        <select name="post_categories[]" id="post_categories_<?php echo esc_attr($taxonomy->name); ?>">
                            <?php foreach ($terms as $term) : ?>
                                <option value="<?php echo esc_attr($term->term_id); ?>">
                                    <?php echo esc_html($term->name); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </label>
                <?php endif;
            endif;
        endforeach;
    endif;

    wp_send_json_success(ob_get_clean());

}
