<?php

// Smart Plugin Add Schedule

add_action('wp_ajax_handle_update_schedule_form', 'handle_update_schedule_form_callback');

add_action('wp_ajax_nopriv_handle_update_schedule_form', 'handle_update_schedule_form_callback');

function handle_update_schedule_form_callback() {

    $schedule_id = sanitize_text_field($_POST['schedule_id']);
    $title = sanitize_text_field($_POST['title']);
    $prompt = sanitize_text_field($_POST['prompt']);
    $language = sanitize_text_field($_POST['language']);
    $post_type = sanitize_text_field($_POST['post_type']);
    $categories = $_POST['categories'] ?? [];
    $model = sanitize_text_field($_POST['model']);
    $article_image_id = sanitize_text_field($_POST['article_image_id']);
    $generateImage = sanitize_text_field($_POST['generateImage']);
    $schedule_datetime = sanitize_text_field($_POST['schedule_datetime']);

    if( !empty($article_image_id) ) {

        $generateImage = false;
    }

    $schedule_lists = get_user_meta(1, 'schedule_lists', true);

    if (!is_array($schedule_lists)) $schedule_lists = [];

    if (isset($schedule_lists[$schedule_id])) {
        unset($schedule_lists[$schedule_id]);
        $schedule_lists = array_values($schedule_lists);
    }

    $new_schedule = [
        'title' => $title,
        'prompt' => $prompt,
        'language' => $language,
        'post_type' => $post_type,
        'categories' => $categories,
        'model' => $model,
        'article_image_id' => $article_image_id,
        'generateImage' => $generateImage,
        'schedule_datetime' => $schedule_datetime,
        'created_at' => current_time('mysql'),
    ];

    $schedule_lists[] = $new_schedule;

    update_user_meta(1, 'schedule_lists', $schedule_lists);

    wp_send_json_success('Schedule saved successfully.');

}