<?php

// Smart Plugin Validate API

add_action('wp_ajax_smart_plugin_validate_api', 'smart_plugin_validate_api_callback');

function smart_plugin_validate_api_callback() {

    if (empty($_POST['api_key'])) {
        
        wp_send_json_error('API key is missing.');
    }

    $api_key  = sanitize_text_field($_POST['api_key']);
    $site_url = esc_url_raw($_POST['site_url']);

    $response = wp_remote_post('https://smart-plugin.com/wp-json/apivalidate-api/v1/receive-data/', [
        'headers' => ['Content-Type' => 'application/json'],
        'body'    => json_encode([
            'api_key'  => $api_key,
            'site_url' => $site_url,
        ]),
    ]);

    if (is_wp_error($response)) {

        update_user_meta(1, 'smart_plugin_license_key', '');
        update_user_meta(1, 'smart_plugin_multimodel', false);
        update_user_meta(1, 'smart_plugin_generateImage', false);
        update_user_meta(1, 'smart_plugin_schedule', false);
        update_user_meta(1, 'smart_plugin_features', '');

        wp_send_json_error('Request failed: ' . esc_html($response->get_error_message()) );
    }

    $code = wp_remote_retrieve_response_code($response);

    if ($code !== 200) {

        update_user_meta(1, 'smart_plugin_license_key', '');
        update_user_meta(1, 'smart_plugin_multimodel', false);
        update_user_meta(1, 'smart_plugin_generateImage', false);
        update_user_meta(1, 'smart_plugin_schedule', false);
        update_user_meta(1, 'smart_plugin_features', '');

        wp_send_json_error('Server error: HTTP ' . $code );
    }

    $body = json_decode(wp_remote_retrieve_body($response), true);

    if (json_last_error() !== JSON_ERROR_NONE || !is_array($body)) {

        update_user_meta(1, 'smart_plugin_license_key', '');
        update_user_meta(1, 'smart_plugin_multimodel', false);
        update_user_meta(1, 'smart_plugin_generateImage', false);
        update_user_meta(1, 'smart_plugin_schedule', false);
        update_user_meta(1, 'smart_plugin_features', '');

        wp_send_json_error('Invalid JSON response from server.');
    }

    if (!empty($body['status']) && $body['status'] === 'success') {

        $multimodel = filter_var($body['plan'][0]['multimodel'] ?? false, FILTER_VALIDATE_BOOLEAN);
        $generateImage = filter_var($body['plan'][0]['generateImage'] ?? false, FILTER_VALIDATE_BOOLEAN);
        $schedule = filter_var($body['plan'][0]['schedule'] ?? false, FILTER_VALIDATE_BOOLEAN);
        $plan_features = !empty($body['plan'][0]['plan_features']) ? $body['plan'][0]['plan_features'] : [];

        update_user_meta(1, 'smart_plugin_license_key', $api_key);
        update_user_meta(1, 'smart_plugin_multimodel', $multimodel ? 1 : 0);
        update_user_meta(1, 'smart_plugin_generateImage', $generateImage ? 1 : 0);
        update_user_meta(1, 'smart_plugin_schedule', $schedule ? 1 : 0);
        update_user_meta(1, 'smart_plugin_features', $plan_features);

        $features_html = '<div class="api_response_container"><h3><svg fill="#ffffff" width="256px" height="256px" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" stroke="#ffffff"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><path d="M505.12019,19.09375c-1.18945-5.53125-6.65819-11-12.207-12.1875C460.716,0,435.507,0,410.40747,0,307.17523,0,245.26909,55.20312,199.05238,128H94.83772c-16.34763.01562-35.55658,11.875-42.88664,26.48438L2.51562,253.29688A28.4,28.4,0,0,0,0,264a24.00867,24.00867,0,0,0,24.00582,24H127.81618l-22.47457,22.46875c-11.36521,11.36133-12.99607,32.25781,0,45.25L156.24582,406.625c11.15623,11.1875,32.15619,13.15625,45.27726,0l22.47457-22.46875V488a24.00867,24.00867,0,0,0,24.00581,24,28.55934,28.55934,0,0,0,10.707-2.51562l98.72834-49.39063c14.62888-7.29687,26.50776-26.5,26.50776-42.85937V312.79688c72.59753-46.3125,128.03493-108.40626,128.03493-211.09376C512.07526,76.5,512.07526,51.29688,505.12019,19.09375ZM384.04033,168A40,40,0,1,1,424.05,128,40.02322,40.02322,0,0,1,384.04033,168Z"></path></g></svg>Plan Features</h3>';
        
        if( !empty($plan_features) ) {

            foreach ($plan_features as $key => $data) {

                list($label, $value) = $data;

                if( $key == 'upgrade_url') {

                    $features_html .= '<a href="'.$value.'" target="_blank"><svg width="256px" height="256px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M12.8306 3.443C12.6449 3.16613 12.3334 3 12.0001 3C11.6667 3 11.3553 3.16613 11.1696 3.443L7.38953 9.07917L2.74781 3.85213C2.44865 3.51525 1.96117 3.42002 1.55723 3.61953C1.15329 3.81904 0.932635 4.26404 1.01833 4.70634L3.70454 18.5706C3.97784 19.9812 5.21293 21 6.64977 21H17.3504C18.7872 21 20.0223 19.9812 20.2956 18.5706L22.9818 4.70634C23.0675 4.26404 22.8469 3.81904 22.4429 3.61953C22.039 3.42002 21.5515 3.51525 21.2523 3.85213L16.6106 9.07917L12.8306 3.443Z" fill="#ffffff"></path> </g></svg> Upgrade Plan</a>';

                    break;
                }
            }
        }
        $features_html .= '</div>';

        if( !empty($plan_features) ) {

            $features_html .= "<ul>";

            foreach ($plan_features as $key => $data) {

                list($label, $value) = $data;

                if( $key !== 'upgrade_url') {

                    $features_html .= '<li>';

                    if (is_bool($value)) {

                        $emoji = $value ? '<span class="included"><svg aria-hidden=true class="e-fas-check e-font-icon-svg"viewBox="0 0 512 512"xmlns=http://www.w3.org/2000/svg><path d="M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z"></path></svg> Included</span>' : '<span class="not_included"><svg aria-hidden=true class="e-fas-times e-font-icon-svg"viewBox="0 0 352 512"xmlns=http://www.w3.org/2000/svg><path d="M242.72 256l100.07-100.07c12.28-12.28 12.28-32.19 0-44.48l-22.24-22.24c-12.28-12.28-32.19-12.28-44.48 0L176 189.28 75.93 89.21c-12.28-12.28-32.19-12.28-44.48 0L9.21 111.45c-12.28 12.28-12.28 32.19 0 44.48L109.28 256 9.21 356.07c-12.28 12.28-12.28 32.19 0 44.48l22.24 22.24c12.28 12.28 32.2 12.28 44.48 0L176 322.72l100.07 100.07c12.28 12.28 32.2 12.28 44.48 0l22.24-22.24c12.28-12.28 12.28-32.19 0-44.48L242.72 256z"></path></svg> Not Included<span>';

                        $features_html .= "<span class='feature_name'>{$label}</span> {$emoji}";
                    } else {

                        $features_html .= "<span class='feature_name'>{$label}</span> <span>{$value}</span>";
                    }

                    $features_html .= '</li>';
                }

            }

            $features_html .= "</ul>";

        }

        wp_send_json_success($features_html);

    } else {

        update_user_meta(1, 'smart_plugin_license_key', '');
        update_user_meta(1, 'smart_plugin_multimodel', false);
        update_user_meta(1, 'smart_plugin_generateImage', false);
        update_user_meta(1, 'smart_plugin_schedule', false);
        update_user_meta(1, 'smart_plugin_features', '');

        $message = !empty($body['message']) ? $body['message'] : 'Unknown error';

        wp_send_json_error( esc_html($message) );
    }
}