<?php

// Smart Plugin Cron Events

add_action('smartplugin_schedule_event', 'smartplugin_check_schedules');

function smartplugin_check_schedules() {

    $schedules = get_user_meta(1, 'schedule_lists', true);

    if (!is_array($schedules)) return;

    foreach ($schedules as $key => $schedule) {

        $scheduled_time = strtotime($schedule['schedule_datetime']);

        $now = current_time('timestamp');

        if ($now >= $scheduled_time && empty($schedule['done'])) {

            $_POST['schedule_list'] = $key;
            $_POST['title']         = $schedule['title'];
            $_POST['prompt']        = $schedule['prompt'];
            $_POST['language']      = $schedule['language'];
            $_POST['post_type']     = $schedule['post_type'];
            $_POST['categories']    = $schedule['categories'];
            $_POST['model']         = $schedule['model'];
            $_POST['article_image_id'] = $schedule['article_image_id'];
            $_POST['generateImage'] = $schedule['generateImage'];
            $_POST['api_key'] = get_user_meta(1, 'smart_plugin_license_key', true);
            $_POST['site_url'] = $_SERVER['HTTP_HOST'];

            ob_start();

            if (function_exists('wp_ajax_smart_plugin_generate_callback')) {

                wp_ajax_smart_plugin_generate_callback();
            }

            ob_get_clean();
			
			break;

        }
    }

}