<?php

// Smart Plugin Generation

function smart_plugin_article_generation_page() {

    $license_key = get_user_meta(1, 'smart_plugin_license_key', true);

    if (empty($license_key)) {

        wp_redirect(admin_url('admin.php?page=smart-plugin-license'));
        exit;
    }

    $multimodel = get_user_meta(1, 'smart_plugin_multimodel', true);
    $generateImage = get_user_meta(1, 'smart_plugin_generateImage', true);

    $isMultimodel = (bool) $multimodel;
    $isGenerateImage = (bool) $generateImage;

    ?>

    <div class="wrap">

        <h1 style="display: flex;align-items: center;gap: 6px;font-size: 24px;">
            Smart Plugin - Generate Articles
            <svg width="45px" height="24px" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" fill="#000000" class="bi bi-stars"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M7.657 6.247c.11-.33.576-.33.686 0l.645 1.937a2.89 2.89 0 0 0 1.829 1.828l1.936.645c.33.11.33.576 0 .686l-1.937.645a2.89 2.89 0 0 0-1.828 1.829l-.645 1.936a.361.361 0 0 1-.686 0l-.645-1.937a2.89 2.89 0 0 0-1.828-1.828l-1.937-.645a.361.361 0 0 1 0-.686l1.937-.645a2.89 2.89 0 0 0 1.828-1.828l.645-1.937zM3.794 1.148a.217.217 0 0 1 .412 0l.387 1.162c.173.518.579.924 1.097 1.097l1.162.387a.217.217 0 0 1 0 .412l-1.162.387A1.734 1.734 0 0 0 4.593 5.69l-.387 1.162a.217.217 0 0 1-.412 0L3.407 5.69A1.734 1.734 0 0 0 2.31 4.593l-1.162-.387a.217.217 0 0 1 0-.412l1.162-.387A1.734 1.734 0 0 0 3.407 2.31l.387-1.162zM10.863.099a.145.145 0 0 1 .274 0l.258.774c.115.346.386.617.732.732l.774.258a.145.145 0 0 1 0 .274l-.774.258a1.156 1.156 0 0 0-.732.732l-.258.774a.145.145 0 0 1-.274 0l-.258-.774a1.156 1.156 0 0 0-.732-.732L9.1 2.137a.145.145 0 0 1 0-.274l.774-.258c.346-.115.617-.386.732-.732L10.863.1z"></path> </g></svg>
        </h1>

        <?php

            templates_header_callback();

        ?>

        <div id="request_response"></div>

        <form method="post" id="form_generate_request" enctype="multipart/form-data">

            <h3>
                <svg width="256px" height="256px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path fill-rule="evenodd" clip-rule="evenodd" d="M15.0614 9.67972L16.4756 11.0939L17.8787 9.69083L16.4645 8.27662L15.0614 9.67972ZM16.4645 6.1553L20 9.69083L8.6863 21.0045L5.15076 17.469L16.4645 6.1553Z" fill="#ffffff"></path> <path fill-rule="evenodd" clip-rule="evenodd" d="M11.364 5.06066L9.59619 6.82843L8.53553 5.76777L10.3033 4L11.364 5.06066ZM6.76778 6.82842L5 5.06067L6.06066 4L7.82843 5.76776L6.76778 6.82842ZM10.3033 10.364L8.53553 8.5962L9.59619 7.53554L11.364 9.3033L10.3033 10.364ZM7.82843 8.5962L6.06066 10.364L5 9.3033L6.76777 7.53554L7.82843 8.5962Z" fill="#ffffff"></path> </g></svg>
                Generate Article
            </h3>

            <label for="title"><span>Title</span> <input type="text" name="title" id="title" required></label>

            <label for="prompt"><span>Prompt</span>
                <textarea name="prompt" id="prompt" required></textarea>
            </label>

            <label for="language"><span>Language</span>
                <select name="language" id="language" required>
                    <option value="English">English</option>
                    <option value="Bulgarian">Bulgarian</option>
                    <option value="Czech">Czech</option>
                    <option value="Danish">Danish</option>
                    <option value="Dutch">Dutch</option>
                    <option value="Estonian">Estonian</option>
                    <option value="Finnish">Finnish</option>
                    <option value="French">French</option>
                    <option value="German">German</option>
                    <option value="Greek">Greek</option>
                    <option value="Irish">Irish</option>
                    <option value="Italian">Italian</option>
                    <option value="Latvian">Latvian</option>
                    <option value="Lithuanian">Lithuanian</option>
                    <option value="Maltese">Maltese</option>
                    <option value="Polish">Polish</option>
                    <option value="Portuguese">Portuguese</option>
                    <option value="Romanian">Romanian</option>
                    <option value="Slovak">Slovak</option>
                    <option value="Slovenian">Slovenian</option>
                    <option value="Spanish">Spanish</option>
                    <option value="Swedish">Swedish</option>
                </select>
            </label>

            <label for="post_type"><span>Post Type</span> 
                <select name="post_type" id="post_type" required>
                    <?php
                        $args = array(
                            'public'   => true,
                            '_builtin' => false
                        );

                        $output = 'names';
                        $post_types = get_post_types($args, $output);

                        $builtin = ['post', 'page'];

                        foreach ($builtin as $type) {

                            echo '<option value="' . esc_attr($type) . '">' . esc_html(ucfirst($type)) . '</option>';
                        }

                        foreach ($post_types as $post_type) {

                            echo '<option value="' . esc_attr($post_type) . '">' . esc_html(ucfirst($post_type)) . '</option>';
                        }
                    ?>
                </select>
            </label>

            <style>#taxonomy-field{display: inline;}</style>

            <div id="taxonomy-field">
                <?php
                    $post_type = 'post';
                    $taxonomies = get_object_taxonomies($post_type, 'objects');

                    if (!empty($taxonomies)) :
                        foreach ($taxonomies as $taxonomy) :
                            if ($taxonomy->hierarchical) :
                                $terms = get_terms(array(
                                    'taxonomy' => $taxonomy->name,
                                    'hide_empty' => false,
                                ));
                                if (!empty($terms) && !is_wp_error($terms)) : ?>
                                    <label for="texanomy_<?php echo esc_attr($taxonomy->name); ?>"><span><?php echo esc_html($taxonomy->label); ?></span>
                                        <select name="texanomy_<?php echo esc_attr($taxonomy->name); ?>" id="texanomy_<?php echo esc_attr($taxonomy->name); ?>">
                                            <option value="">Select category</option>
                                            <?php foreach ($terms as $term) : ?>
                                                <option value="<?php echo esc_attr($term->term_id); ?>">
                                                    <?php echo esc_html($term->name); ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </label>
                                <?php endif;
                            endif;
                        endforeach;
                    endif;
                ?>
            </div>

            <script>
                jQuery(document).ready(function($) {

                    $('#post_type').change(function() {
                        var taxonomy_container = $('#taxonomy-field');
                        var postType = $(this).val();
                        $.ajax({
                            url: ajaxurl,
                            method: 'POST',
                            data: {
                                action: 'get_taxonomies_by_post_type',
                                post_type: postType
                            },
                            success: function(response) {
                                taxonomy_container.html(response.data);
                            }
                        });
                    });

                });
            </script>

            <input type="hidden" name="model" id="modelInput" value="deepseek" required>

            <?php if($isMultimodel) { ?>
                
                <div class=switch-container><div class=switch-label>DeepSeek</div> <label class=switch><input id=modelSwitch type=checkbox> <div class=slider></div></label> <div class=switch-label>ChatGPT</div></div>
                
                <script>switchInput=document.getElementById("modelSwitch"),modelInput=document.getElementById("modelInput");switchInput.addEventListener("change",()=>{let e=switchInput.checked?"chatgpt":"deepseek";modelInput.value=e});</script>
            
            <?php } ?>

            <label for="upload-article-image"><span>Upload article image</span>

                <div id="upload-article-image">Select Image</div>

                <svg style="width: 10px;height: 50px;fill: #bf3e3e;cursor: pointer;margin-left: -20px;" class="remove_uploaded_image" fill="#000000" width="256px" height="256px" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M0 14.545L1.455 16 8 9.455 14.545 16 16 14.545 9.455 8 16 1.455 14.545 0 8 6.545 1.455 0 0 1.455 6.545 8z" fill-rule="evenodd"></path> </g></svg>

                <input id="article-image-id" name="article-image-id" type="hidden">

            </label>

            <?php if($isGenerateImage) { ?>

                <label class="checkbox-container" for="generate-image"><input id="generate-image" name="generate-image" type="checkbox"> Generate article image</label>

            <?php } ?>

            <button id="submit_generate_request" type="submit" class="button button-primary">
                <svg width="256px" height="256px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M4 12.6111L8.92308 17.5L20 6.5" stroke="#ffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>
                Generate Article
            </button>

        </form>

        <script type="text/javascript">

            jQuery(document).ready(function($) {

                $('#form_generate_request').on('submit', function(e) {
                    e.preventDefault();

                    let categories = {};
                    $('#taxonomy-field select').each(function () {
                        const taxonomy = $(this).attr('name');
                        const values = $(this).val();
                        if (taxonomy) {
                            if (Array.isArray(values)) { categories[taxonomy] = values; } else if (values) { categories[taxonomy] = [values]; }
                        }
                    });
                    var generateImage = false;
                    var title = $('#title').val();
                    var prompt = $('#prompt').val();
                    var language = $('#language').val();
                    var post_type = $('#post_type').val();
                    var model = $('#modelInput').val();
                    var article_image_id = $('#article-image-id').val();
                    if( $('#generate-image').is(':checked') ) { generateImage = true; }
                    var apiKey = "<?php if(!empty(get_user_meta(1, 'smart_plugin_license_key', true))) { echo get_user_meta(1, 'smart_plugin_license_key', true); } ?>";

                    $('#request_response').html('Generating article ...');

                    $.ajax({
                        url: ajaxurl,
                        type: 'POST',
                        data: {
                            action: 'smart_plugin_generate',
                            title: title,
                            prompt: prompt,
                            language: language,
                            post_type: post_type,
                            categories: categories,
                            model: model,
                            article_image_id: article_image_id,
                            generateImage: generateImage,
                            api_key: apiKey,
                            site_url: window.location.hostname
                        },
                        beforeSend: function() {
                            $('#submit_generate_request').prop('disabled', true);
                        },
                        success: function(response) {

                            $('#request_response').html( response.data );
                        },
                        error: function(xhr, status, error) {

                            $('#request_response').html( error );
                        },
                        complete: function() {
                            $('#submit_generate_request').prop('disabled', false);
                        }
                    });

                });

            });

        </script>

    </div>

    <?php

}