<?php

// Smart Plugin license

function smart_plugin_license_page() {

    ?>

    <div class="wrap">

        <h1 style="display: flex;align-items: center;gap: 6px;font-size: 24px;">
            Smart Plugin - License Key
            <svg width="45px" height="24px" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" fill="#000000"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><rect width="24" height="24" fill="none"></rect><path d="M20,6H4A2,2,0,0,0,2,8v8a2,2,0,0,0,2,2H20a2,2,0,0,0,2-2V8A2,2,0,0,0,20,6ZM9.29,14.8,9,13.73H7.16L6.87,14.8H5.17L7,9.07H9.09L11,14.8Zm6.34-3.14a1.7,1.7,0,0,1-.36.64,1.82,1.82,0,0,1-.67.44,2.75,2.75,0,0,1-1,.17h-.44V14.8H11.6V9.09h2a2.43,2.43,0,0,1,1.62.47,1.67,1.67,0,0,1,.55,1.35A2.36,2.36,0,0,1,15.63,11.66Zm2.58,3.14H16.66V9.09h1.55ZM8.45,11.53l.24.93H7.48l.24-.93c0-.13.08-.28.12-.47s.09-.38.13-.57a4.63,4.63,0,0,0,.1-.48c0,.13.07.29.11.5l.15.58Zm5.59-1a.57.57,0,0,1,.16.43.75.75,0,0,1-.11.42.59.59,0,0,1-.27.22.9.9,0,0,1-.37.07h-.31V10.34h.4A.63.63,0,0,1,14,10.51Z" fill-rule="evenodd"></path></g></svg>
        </h1>

        <div class="api_key_box">
            <h3>
                <svg width="256px" height="256px" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path fill-rule="evenodd" clip-rule="evenodd" d="M16 5.5C16 8.53757 13.5376 11 10.5 11H7V13H5V15L4 16H0V12L5.16351 6.83649C5.0567 6.40863 5 5.96094 5 5.5C5 2.46243 7.46243 0 10.5 0C13.5376 0 16 2.46243 16 5.5ZM13 4C13 4.55228 12.5523 5 12 5C11.4477 5 11 4.55228 11 4C11 3.44772 11.4477 3 12 3C12.5523 3 13 3.44772 13 4Z" fill="#ffffff"></path> </g></svg>
                License Information
            </h3>
            <div class="input_container">
                <input type="text" name="api_key" id="api_key" class="regular-text" placeholder="Enter API Key" value="<?php if(!empty(get_user_meta(1, 'smart_plugin_license_key', true))) { echo get_user_meta(1, 'smart_plugin_license_key', true); } ?>" required>
            </div>
            <button id="submit_api_key" class="button button-primary">
                <svg width="256px" height="256px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M4 12.6111L8.92308 17.5L20 6.5" stroke="#ffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>
                Submit Changes
            </button>
        </div>
        <div id="api_response">

            <?php
                $plan_features = !empty(get_user_meta(1, 'smart_plugin_features', true)) ? get_user_meta(1, 'smart_plugin_features', true) : [];            
            ?>

            <div class="api_response_container">
                <h3>
                    <svg fill="#ffffff" width="256px" height="256px" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" stroke="#ffffff"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><path d="M505.12019,19.09375c-1.18945-5.53125-6.65819-11-12.207-12.1875C460.716,0,435.507,0,410.40747,0,307.17523,0,245.26909,55.20312,199.05238,128H94.83772c-16.34763.01562-35.55658,11.875-42.88664,26.48438L2.51562,253.29688A28.4,28.4,0,0,0,0,264a24.00867,24.00867,0,0,0,24.00582,24H127.81618l-22.47457,22.46875c-11.36521,11.36133-12.99607,32.25781,0,45.25L156.24582,406.625c11.15623,11.1875,32.15619,13.15625,45.27726,0l22.47457-22.46875V488a24.00867,24.00867,0,0,0,24.00581,24,28.55934,28.55934,0,0,0,10.707-2.51562l98.72834-49.39063c14.62888-7.29687,26.50776-26.5,26.50776-42.85937V312.79688c72.59753-46.3125,128.03493-108.40626,128.03493-211.09376C512.07526,76.5,512.07526,51.29688,505.12019,19.09375ZM384.04033,168A40,40,0,1,1,424.05,128,40.02322,40.02322,0,0,1,384.04033,168Z"></path></g></svg>
                    Plan Features
                </h3>
                <?php
                    if( !empty($plan_features) ) {

                        foreach ($plan_features as $key => $data) {

                            list($label, $value) = $data;

                            if( $key == 'upgrade_url') {

                                ?>

                                <a href="<?php echo $value; ?>" target="_blank">
                                    <svg width="256px" height="256px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M12.8306 3.443C12.6449 3.16613 12.3334 3 12.0001 3C11.6667 3 11.3553 3.16613 11.1696 3.443L7.38953 9.07917L2.74781 3.85213C2.44865 3.51525 1.96117 3.42002 1.55723 3.61953C1.15329 3.81904 0.932635 4.26404 1.01833 4.70634L3.70454 18.5706C3.97784 19.9812 5.21293 21 6.64977 21H17.3504C18.7872 21 20.0223 19.9812 20.2956 18.5706L22.9818 4.70634C23.0675 4.26404 22.8469 3.81904 22.4429 3.61953C22.039 3.42002 21.5515 3.51525 21.2523 3.85213L16.6106 9.07917L12.8306 3.443Z" fill="#ffffff"></path> </g></svg>
                                    Upgrade Plan
                                </a>

                                <?php

                                break;
                            }
                        }
                    }
                ?>
            </div>

            <?php

                if( !empty($plan_features) ) {

                    $features_html = "<ul>";

                    foreach ($plan_features as $key => $data) {

                        list($label, $value) = $data;

                        if( $key !== 'upgrade_url') {

                            $features_html .= '<li>';

                            if (is_bool($value)) {

                                $emoji = $value ? '<span class="included"><svg aria-hidden=true class="e-fas-check e-font-icon-svg"viewBox="0 0 512 512"xmlns=http://www.w3.org/2000/svg><path d="M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z"></path></svg> Included</span>' : '<span class="not_included"><svg aria-hidden=true class="e-fas-times e-font-icon-svg"viewBox="0 0 352 512"xmlns=http://www.w3.org/2000/svg><path d="M242.72 256l100.07-100.07c12.28-12.28 12.28-32.19 0-44.48l-22.24-22.24c-12.28-12.28-32.19-12.28-44.48 0L176 189.28 75.93 89.21c-12.28-12.28-32.19-12.28-44.48 0L9.21 111.45c-12.28 12.28-12.28 32.19 0 44.48L109.28 256 9.21 356.07c-12.28 12.28-12.28 32.19 0 44.48l22.24 22.24c12.28 12.28 32.2 12.28 44.48 0L176 322.72l100.07 100.07c12.28 12.28 32.2 12.28 44.48 0l22.24-22.24c12.28-12.28 12.28-32.19 0-44.48L242.72 256z"></path></svg> Not Included<span>';

                                $features_html .= "<span class='feature_name'>{$label}</span> {$emoji}";
                            } else {

                                $features_html .= "<span class='feature_name'>{$label}</span> <span>{$value}</span>";
                            }

                            $features_html .= '</li>';
                        }

                    }

                    $features_html .= "</ul>";

                    echo $features_html;

                } else {

                    echo '<p style="margin: 20px 0px 0px 0px;">No plan is currently active.</p>';
                }
            ?>
        </div>

    </div>

    <script type="text/javascript">

        jQuery(document).ready(function($) {

            $('#submit_api_key').on('click', function(e) {

                e.preventDefault();

                var apiKey = $('#api_key').val();

                $('#api_response').html('<p>Sending validation request ...</p>');

                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'smart_plugin_validate_api',
                        api_key: apiKey,
                        site_url: window.location.hostname
                    },
                    beforeSend: function() {
                        $('#submit_api_key').prop('disabled', true);
                    },
                    success: function(response) {

                        $('#api_response').html(response.data);
                    },
                    error: function(xhr, status, error) {

                        $('#api_response').html('<p>' + error + '</p>');
                    },
                    complete: function() {
                        $('#submit_api_key').prop('disabled', false);
                    }
                });

            });

        });

    </script>

    <?php

}