<?php

// Smart Plugin Schedule

function display_value($value) {

    return !empty($value) ? esc_html($value) : 'Null';
}

function smart_plugin_schedule_page() {

    $license_key = get_user_meta(1, 'smart_plugin_license_key', true);

    if (empty($license_key)) {

        wp_redirect(admin_url('admin.php?page=smart-plugin-license'));
        exit;
    }

    $multimodel = get_user_meta(1, 'smart_plugin_multimodel', true);
    $generateImage = get_user_meta(1, 'smart_plugin_generateImage', true);
    $schedule = get_user_meta(1, 'smart_plugin_schedule', true);

    $isMultimodel = (bool) $multimodel;
    $isGenerateImage = (bool) $generateImage;
    $isSchedule = (bool) $schedule;

    if( $isSchedule ) {

        ?>

        <div class="wrap">

            <h1 style="display: flex;align-items: center;gap: 6px;font-size: 24px;">
                Smart Plugin - Schedule
                <svg fill="#000000" width="45px" height="24px" viewBox="0 -16 544 544" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><path d="M27.12 392h105.76c6.12 0 11.12 5 11.12 11.12v25.76c0 6.12-5 11.12-11.12 11.12H27.12C21 440 16 435 16 428.88v-25.76C16 397 21 392 27.12 392zm0-160h105.76c6.12 0 11.12 5.01 11.12 11.12v25.76c0 6.12-5 11.12-11.12 11.12H27.12C21 280 16 275 16 268.88v-25.76c0-6.11 5-11.12 11.12-11.12zM48 80v32h64V80H48zm192 160v32h64v-32h-64zm0-160v32h64V80h-64zm192 0v32h64V80h-64zm0 160v32h64v-32h-64zM240 400v32h64v-32h-64zm171.12-8h105.76c6.12 0 11.12 5 11.12 11.12v25.76c0 6.12-5 11.12-11.12 11.12H411.12c-6.11 0-11.12-5-11.12-11.12v-25.76c0-6.12 5.01-11.12 11.12-11.12zM208 352h128c8.8 0 16 7.2 16 16v96c0 8.8-7.2 16-16 16H208c-8.8 0-16-7.2-16-16v-96c0-8.8 7.2-16 16-16zm192-160h128c8.8 0 16 7.2 16 16v96c0 8.8-7.2 16-16 16H400c-8.8 0-16-7.2-16-16v-96c0-8.8 7.2-16 16-16zm0-160h128c8.8 0 16 7.2 16 16v96c0 8.8-7.2 16-16 16H400c-8.8 0-16-7.2-16-16V48c0-8.8 7.2-16 16-16zm-192 0h128c8.8 0 16 7.2 16 16v96c0 8.8-7.2 16-16 16H208c-8.8 0-16-7.2-16-16V48c0-8.8 7.2-16 16-16zm0 160h128c8.8 0 16 7.2 16 16v96c0 8.8-7.2 16-16 16H208c-8.8 0-16-7.2-16-16v-96c0-8.8 7.2-16 16-16zM16 32h128c8.8 0 16 7.2 16 16v96c0 8.8-7.2 16-16 16H16c-8.8 0-16-7.2-16-16V48c0-8.8 7.2-16 16-16z"></path></g></svg>
            </h1>

            <div class="overlay_form"></div>

            <ul class="schedule_lists">

                <?php
                    $schedule_lists = get_user_meta(1, 'schedule_lists', true);

                    if (!empty($schedule_lists) && is_array($schedule_lists)) {

                        foreach ($schedule_lists as $index => $schedule) {
                            
                            ?>
                                <li class="schedule_list">
                                    <div class="li_header">
                                        <?php echo ($index + 1); ?>. <?php echo $schedule['title']; ?>
                                        <?php if( !empty($schedule['done']) ) { echo "<span class='message'>Article generated</span>"; } ?>
                                        <button schdule_id="<?php echo $index; ?>" class="edit" type="button">
                                            <svg fill="#000000" width="256px" height="256px" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><path d="M20.7,5.2a1.024,1.024,0,0,1,0,1.448L18.074,9.276l-3.35-3.35L17.35,3.3a1.024,1.024,0,0,1,1.448,0Zm-4.166,5.614-3.35-3.35L4.675,15.975,3,21l5.025-1.675Z"></path></g></svg>
                                        </button>
                                        <form method="post" class="remove_schedule">
                                            <input type="hidden" class="remove_schedule_index" name="remove_schedule_index" value="<?php echo $index; ?>">
                                            <button type="submit" name="remove_schedule">
                                                <svg fill="#000000" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M0 14.545L1.455 16 8 9.455 14.545 16 16 14.545 9.455 8 16 1.455 14.545 0 8 6.545 1.455 0 0 1.455 6.545 8z" fill-rule="evenodd"></path> </g></svg>
                                            </button>
                                        </form>
                                    </div>
                                    <div class="li_content">
                                        <?php
                                            $term_names = [];
                                            if (!empty($schedule['categories']) && is_array($schedule['categories'])) {
                                                foreach ($schedule['categories'] as $taxonomy => $term_ids) {
                                                    if (is_array($term_ids) && !empty($term_ids)) {

                                                        foreach ($term_ids as $term_id) {
                                                            $taxonomy = end(explode('_', $taxonomy));
                                                            $term = get_term($term_id, $taxonomy);
                                                            if (!is_wp_error($term) && $term) {
                                                                $term_names[] = $term->name;
                                                            }
                                                        }

                                                    }
                                                }
                                            }

                                            $uploaded_image_url = wp_get_attachment_image_url($schedule['article_image_id'], 'full');

                                            echo '<p><strong>Title:</strong> ' . display_value($schedule['title']) . '</p>';
                                            echo '<p><strong>Prompt:</strong> ' . display_value($schedule['prompt']) . '</p>';
                                            echo '<p><strong>Language:</strong> ' . display_value($schedule['language']) . '</p>';
                                            echo '<p><strong>Post Type:</strong> ' . display_value($schedule['post_type']) . '</p>';
                                            echo '<p><strong>Taxonomy:</strong> ' . (!empty($term_names) ? esc_html(implode(", ", $term_names)) : 'Null') . '</p>';
                                            echo '<p><strong>Model:</strong> ' . display_value($schedule['model']) . '</p>';
                                            echo '<p><strong>Uploaded Image:</strong> ' . ($uploaded_image_url ? esc_url($uploaded_image_url) : 'Null') . '</p>';
                                            echo '<p><strong>Generate Image:</strong> ' . display_value($schedule['generateImage']) . '</p>';
                                            echo '<p><strong>Schedule Datetime:</strong> ' . display_value($schedule['schedule_datetime']) . '</p>';
                                            echo '<p><strong>Created At:</strong> ' . display_value($schedule['created_at']) . '</p>';                      
                                        ?>
                                    </div>
                                </li>
                            <?php
                        }

                    }
                ?>

            </ul>

            <button type="button" class="add_schedule_list">
                <svg fill="#ffffff" height="200px" width="200px" version="1.1" id="Icons" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 32 32" xml:space="preserve" stroke="#ffffff"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g> <path d="M28,5h-6V3c0-0.6-0.4-1-1-1s-1,0.4-1,1v2h-8V3c0-0.6-0.4-1-1-1s-1,0.4-1,1v2H4C3.4,5,3,5.4,3,6v4h26V6C29,5.4,28.6,5,28,5z "></path> <path d="M3,28c0,0.6,0.4,1,1,1h18v-6c0-0.5,0.4-0.9,0.9-1c1.4-0.1,3.5-1.6,4.3-2.6C28.9,17.2,29,16,29,16v-4H3V28z"></path> <path d="M24,23.8V29c0.2,0,0.3-0.1,0.5-0.2l0.9-0.9c2-2,3.2-4.6,3.5-7.4c0,0.1-0.1,0.1-0.1,0.2C27.8,21.9,25.8,23.3,24,23.8z"></path> </g> </g></svg>
                Add Schedule
            </button>

            <div class="schedule_form"></div>

            <script>
                jQuery(document).ready(function($) {

                    $('.add_schedule_list').click(function (e) {

                        e.preventDefault();

                        $('.wrap').addClass('form_open');

                        $.ajax({
                            url: ajaxurl,
                            type: 'POST',
                            data: {
                                action: 'get_schedule_form'
                            },
                            success: function (response) {
                                if (response.success && response.data) {
                                    $('.schedule_form').html(response.data);
                                }
                            },
                            error: function () { }
                        });
                    });

                    $('.edit').click(function (e) {

                        e.preventDefault();

                        $('.wrap').addClass('form_open');

                        var schdule_id = $(this).attr('schdule_id');

                        $.ajax({
                            url: ajaxurl,
                            type: 'POST',
                            data: {
                                action: 'get_schedule_form',
                                update_schedule_id: schdule_id
                            },
                            success: function (response) {
                                if (response.success && response.data) {
                                    $('.schedule_form').html(response.data);
                                }
                            },
                            error: function () { }
                        });

                    });

                    jQuery(document).on('click','.close_pop', function (e) {

                        $('.schedule_form').html('');
                        
                        $('.wrap').removeClass('form_open');

                    });

                    jQuery(document).on('click','.overlay_form', function (e) {

                        $('.schedule_form').html('');
                        
                        $('.wrap').removeClass('form_open');

                    });

                    $('.remove_schedule').on('submit', function(e) {
                        e.preventDefault();

                        var remove_schedule_index = $(this).find('.remove_schedule_index').val();

                        $.ajax({
                            url: ajaxurl,
                            type: 'POST',
                            data: {
                                action: 'remove_schedule',
                                remove_schedule_index: remove_schedule_index,
                            },
                            success: function(response) { window.location.reload(); },
                            error: function(xhr, status, error) { }
                        });

                    });

                    $(document).on('submit','.update_form_generate_request', function(e) {
                        e.preventDefault();

                        let categories = {};
                        $('#taxonomy-field select').each(function () {
                            const taxonomy = $(this).attr('name');
                            const values = $(this).val();
                            if (taxonomy) {
                                if (Array.isArray(values)) { categories[taxonomy] = values; } else if (values) { categories[taxonomy] = [values]; }
                            }
                        });
                        var generateImage = false;
                        var schedule_id = $('#schedule_id').val();
                        var title = $('#title').val();
                        var prompt = $('#prompt').val();
                        var language = $('#language').val();
                        var post_type = $('#post_type').val();
                        var model = $('#modelInput').val();
                        var article_image_id = $('#article-image-id').val();
                        var schedule_datetime = $('#schedule_datetime').val();
                        if( $('#generate-image').is(':checked') ) { generateImage = true; }

                        $.ajax({
                            url: ajaxurl,
                            type: 'POST',
                            data: {
                                action: 'handle_update_schedule_form',
                                schedule_id: schedule_id,
                                title: title,
                                prompt: prompt,
                                language: language,
                                post_type: post_type,
                                categories: categories,
                                model: model,
                                article_image_id: article_image_id,
                                generateImage: generateImage,
                                schedule_datetime: schedule_datetime,
                            },
                            beforeSend: function() {
                                $('#add_schedule').text('Saving schedule ...').prop('disabled', true);
                            },
                            success: function(response) { window.location.reload(); },
                            error: function(xhr, status, error) { },
                            complete: function() {
                                $('#add_schedule').text('Update schedule').prop('disabled', false);
                            }
                        });

                    });

                    $(document).on('submit','.add_form_generate_request', function(e) {
                        e.preventDefault();

                        let categories = {};
                        $('#taxonomy-field select').each(function () {
                            const taxonomy = $(this).attr('name');
                            const values = $(this).val();
                            if (taxonomy) {
                                if (Array.isArray(values)) { categories[taxonomy] = values; } else if (values) { categories[taxonomy] = [values]; }
                            }
                        });
                        var generateImage = false;
                        var title = $('#title').val();
                        var prompt = $('#prompt').val();
                        var language = $('#language').val();
                        var post_type = $('#post_type').val();
                        var model = $('#modelInput').val();
                        var article_image_id = $('#article-image-id').val();
                        var schedule_datetime = $('#schedule_datetime').val();
                        if( $('#generate-image').is(':checked') ) { generateImage = true; }

                        $.ajax({
                            url: ajaxurl,
                            type: 'POST',
                            data: {
                                action: 'handle_schedule_form',
                                title: title,
                                prompt: prompt,
                                language: language,
                                post_type: post_type,
                                categories: categories,
                                model: model,
                                article_image_id: article_image_id,
                                generateImage: generateImage,
                                schedule_datetime: schedule_datetime,
                            },
                            beforeSend: function() {
                                $('#add_schedule').text('Saving schedule ...').prop('disabled', true);
                            },
                            success: function(response) { window.location.reload(); },
                            error: function(xhr, status, error) { },
                            complete: function() {
                                $('#add_schedule').text('+ Add schedule').prop('disabled', false);
                            }
                        });

                    });

                });
           
            </script>

        </div>

        <?php

    }

}